IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Liquido_Producto') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Liquido_Producto
END
GO


CREATE PROCEDURE [dbo].[CP_Liquido_Producto](
     @pFechaDesde DATETIME
   , @pFechaHasta DATETIME
   , @pNro_Lote Varchar(20)
   , @pGenerarLiquidacion TINYINT
   , @pId_Proveedor INT
   , @pIncluirPerccep TINYINT
   )
AS
  CREATE TABLE #Trans (Id_Trans INT)

  DECLARE @Id_Producto Varchar(14)
  ,@Id_Proveedor Int
  ,@Razon_Social VarChar(100)
  ,@Cuit Varchar(13)
  ,@Id_Iva Char(3)
  ,@Id_Alias_Cta_Cont Int
  ,@Id_Cta_Contable_H Int
  ,@Porc_Comision_Prov Decimal(7,2) 
  ,@Importe Decimal(12,2) 
  ,@IMPORTE_CREDITO Decimal(12,2) 
  ,@ID_TIPO_CBTE CHAR(4) 
  ,@FECHA DATETIME
  ,@Imp_prod_siva  Decimal(12,2) 
  ,@TRANS INT
  ,@Id_Cliente_Externo VARCHAR(14)
  ,@Id_Cta_Banco INT
  ,@Id_Cliente INT
  ,@Plazo    INT
  ,@PORCENTAJE DECIMAL(12,2)
  ,@Descripcion_Producto VarChar(200)
  ,@CANTIDAD INT
  ,@Precio DECIMAL(12,2)
  ,@ErrorRetorno Int
  ,@IMP_RETENCIONES DECIMAL(12,2)
  ,@TOTAL_FACTURADO DECIMAL(12,2)
  ,@Fecha_Desde_Retencion DATETIME
  ,@COMPROBANTE_NRO INT
  ,@TRANSACCION INT
  ,@CANT INT
  ,@DETALLE_FACTURAS VarChar(800)
  ,@IMP_RETEN_ACUM DECIMAL(12,2)
  ,@CANT_REGISTROS INT
  ,@CANT_GENERADOS INT

  DECLARE @Respuesta Table (
     ErrorNumber    int,
	  ErrorSeverity  INT,
	  ErrorState     INT,
	  ErrorProcedure INT,
	  ErrorLine      INT, 
      ErrorMessage   VARCHAR(100)
	  )

/*Facturas que componene la NVLP*/
 DECLARE @Trans_FC_NVLP TABLE (Id_Trans_NVLP_Destino INT, Id_Trans_FacVenta_Origen	INT)


  SET @CANT_GENERADOS = 0
  SET @FECHA = @pFechaHasta /*Modificado 27/11/19 antes tomaba la fecha del dia*/

  SET @Fecha_Desde_Retencion = (SELECT DBO.CF_FOMONTH(@pFechaDesde))

  
  IF @pIncluirPerccep = 1
		    BEGIN 
			    SELECT C.ID_TRANS,TR.ID_TIPO_RETEN_DEST,R.IMPORTE INTO #TOTRETENIVA
				FROM cbtes c, cbtes_tipos t, cbtes_reten r,CBTES_RETEN_TIPOS TR
				where c.id_trans = r.id_trans
				AND R.Id_Tipo_Reten = TR.ID_TIPO_RETEN
				AND c.id_tipo_cbte = t.id_tipo_cbte 
				AND t.Compromete_Recibos in (1,-1)
				AND TR.TIPO = 'R'
				AND TR.TIPO_IMP = 'V'
				AND C.ID_ESTADO_CBTE <> 3
				AND c.Fecha >= @Fecha_Desde_Retencion
                AND c.Fecha <  DATEADD (dd, 1, @pFechaHasta) 

              			     
               SELECT DISTINCT C.ID_TRANS ,
               CASE WHEN (select max(V1.Porc_Desc_Liquidacion) 
				FROM cbtes c1, cbtes_tipos t1, cbtes_reten r1 , cbtes f1, cbtes_aplica a1, Cbtes_Cond_Vtas v1,CBTES_RETEN_TIPOS TR1
				where c1.id_trans = r1.id_trans
				AND R1.Id_Tipo_Reten = TR1.ID_TIPO_RETEN
				AND c1.id_trans = a1.id_trans_d
				AND f1.id_trans = a1.id_trans
				AND f1.Id_Cond_Vta = V1.Id_Cond_Vta
				AND c1.id_tipo_cbte = t1.id_tipo_cbte 
				AND t1.Compromete_Recibos in (1,-1)
				AND TR1.TIPO = 'R'
				AND TR1.TIPO_IMP = 'V'
				AND c1.Fecha >= @Fecha_Desde_Retencion
                AND c1.Fecha <  DATEADD (dd, 1, @pFechaHasta) 
				AND C1.ID_ESTADO_CBTE <> 3
				AND C1.iD_TRANS = C.ID_TRANS
				GROUP BY C1.iD_TRANS) = 0 THEN 30 
		      ELSE
		       (select max(V1.Porc_Desc_Liquidacion) 
				FROM cbtes c1, cbtes_tipos t1, cbtes_reten r1 , cbtes f1, cbtes_aplica a1, Cbtes_Cond_Vtas v1,CBTES_RETEN_TIPOS TR1
				where c1.id_trans = r1.id_trans
				AND R1.Id_Tipo_Reten = TR1.ID_TIPO_RETEN
				AND c1.id_trans = a1.id_trans_d
				AND f1.id_trans = a1.id_trans
				AND f1.Id_Cond_Vta = V1.Id_Cond_Vta
				AND c1.id_tipo_cbte = t1.id_tipo_cbte 
				AND t1.Compromete_Recibos in (1,-1)
				AND TR1.TIPO = 'R'
				AND TR1.TIPO_IMP = 'V'
				AND c1.Fecha >= @Fecha_Desde_Retencion
                AND c1.Fecha <  DATEADD (dd, 1, @pFechaHasta) 
				AND C1.ID_ESTADO_CBTE <> 3
				AND C1.iD_TRANS = C.ID_TRANS
				GROUP BY C1.iD_TRANS)
		     END AS PORC
  			 INTO #PORC_DESCUENTO

			 FROM cbtes c, cbtes_tipos t, cbtes_reten r , cbtes f, cbtes_aplica a, Cbtes_Cond_Vtas v,CBTES_RETEN_TIPOS TR
			 where c.id_trans = r.id_trans
			 AND R.Id_Tipo_Reten = TR.ID_TIPO_RETEN
			 AND c.id_trans = a.id_trans_d
			 AND f.id_trans = a.id_trans
			 AND f.Id_Cond_Vta = V.Id_Cond_Vta
			 AND c.id_tipo_cbte = t.id_tipo_cbte 
			 AND t.Compromete_Recibos in (1,-1)
			 AND TR.TIPO = 'R'
			 AND TR.TIPO_IMP = 'V'
			 AND C.ID_ESTADO_CBTE <> 3
		     AND c.Fecha >= @Fecha_Desde_Retencion
             AND c.Fecha <  DATEADD (dd, 1, @pFechaHasta) 
			

			   SET @IMP_RETENCIONES = (SELECT SUM(IMPORTE - (IMPORTE * PORC/100)) FROM #PORC_DESCUENTO V, #TOTRETENIVA T WHERE V.ID_TRANS = T.ID_TRANS) 

               SET @IMP_RETEN_ACUM = 0

			   DECLARE @ID_TIPO_RETEN_DEST VARCHAR(10)
			   SET @ID_TIPO_RETEN_DEST = (SELECT TOP 1 ID_TIPO_RETEN_DEST FROM #TOTRETENIVA)

            END

 -- BEGIN  

   
  SELECT P.Id_PROVEEDOR,isnull(v.Plazo_Venc,0) PLAZO,isnull(v.Porc_Desc_Liquidacion,30) PORCENTAJE,SUM(I.Imp_Gravado*T.COMPROMETE_FACTURA) IMPORTE
	INTO #Res_Cond_Vta FROM cbtes c, Cbtes_Cond_Vtas v, cbtes_tipos t, CBTES_ITEMS I, PRODUCTOS P
	where c.id_tipo_cbte = t.Id_Tipo_Cbte
	AND P.Id_PROVEEDOR = @pId_Proveedor
	AND t.Compromete_Factura in (1,-1)
	AND c.id_cond_vta = v.Id_Cond_Vta 
	AND c.Id_Estado_Cbte <> 3 
	AND c.Fecha >= @pFechaDesde
    AND c.Fecha <  DATEADD (dd, 1, @pFechaHasta) 
	AND V.Porc_Desc_Liquidacion > 0 AND I.ID_TRANS = C.ID_TRANS
	AND I.Id_Producto = P.Id_Producto
	   GROUP BY P.Id_PROVEEDOR,v.Plazo_Venc,v.Porc_Desc_Liquidacion HAVING SUM(I.Imp_Gravado*T.COMPROMETE_FACTURA) <> 0
	   ORDER BY P.Id_PROVEEDOR

 IF @pGenerarLiquidacion <> 1
    SELECT * FROM #Res_Cond_Vta
    
 IF @pGenerarLiquidacion = 1
    BEGIN
       
       SET @TOTAL_FACTURADO = (SELECT SUM(IMPORTE*(1-PORCENTAJE/100)) FROM #Res_Cond_Vta)
       SET @CANT_REGISTROS = (SELECT COUNT(*) FROM #Res_Cond_Vta)  

	   DECLARE CUR_GENERAR CURSOR FOR

	   SELECT * FROM #Res_Cond_Vta

	   OPEN CUR_GENERAR
	   FETCH NEXT FROM CUR_GENERAR INTO  @Id_Proveedor,@Plazo,@PORCENTAJE,@Importe
	   WHILE @@FETCH_STATUS = 0
	   BEGIN
	        DELETE #Trans
			IF @Id_Proveedor > 0
        		BEGIN
				   SET @ID_TIPO_CBTE = (SELECT Valor_String FROM xParametros where SETDatos= 1 AND idParametro ='T_Cbte_NV_Liq_Prod')
			   --    SET @ID_TIPO_CBTE = 'NVLP'

				   SET @Razon_Social = (SELECT Razon_Social FROM Proveedores where Id_Proveedor = @Id_Proveedor)
				   INSERT INTO #Trans
			    		EXEC @ErrorRetorno = dbo.CP_Cbtes_Cpra_Generar_Cabe @Id_Proveedor,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',1,@Plazo,100,@trans OUTPUT
						SET @CANT_GENERADOS = @CANT_GENERADOS+1
			       IF @ErrorRetorno <> 0
				      RETURN 1

				END

		  DECLARE CUR_GENERAR_DETALLE CURSOR FOR

		  SELECT I.ID_PRODUCTO,I.Descripcion_producto,Round(I.Precio,02),SUM(I.Cantidad*T.COMPROMETE_FACTURA) CANTIDAD 
		  FROM cbtes c, Cbtes_Cond_Vtas v, cbtes_tipos t, CBTES_ITEMS I, PRODUCTOS P
			where c.id_tipo_cbte = t.Id_Tipo_Cbte AND t.Compromete_Factura in (1,-1) AND c.id_cond_vta = v.Id_Cond_Vta 
			AND c.Id_Estado_Cbte <> 3 
			AND c.Fecha >= @pFechaDesde
			AND c.Fecha <  DATEADD (dd, 1, @pFechaHasta) 
			AND P.Id_PROVEEDOR = @Id_Proveedor
			AND v.Plazo_Venc = @PLAZO
			AND v.Porc_Desc_Liquidacion = @PORCENTAJE
			AND v.Porc_Desc_Liquidacion > 0 
			AND I.Precio <> 0
			AND I.ID_TRANS = C.ID_TRANS
	 		AND I.Id_Producto = P.Id_Producto
			GROUP BY I.ID_PRODUCTO,I.Descripcion_producto,Round(I.Precio,02)

		  OPEN CUR_GENERAR_DETALLE
		  FETCH NEXT FROM CUR_GENERAR_DETALLE INTO  @Id_Producto,@Descripcion_Producto,@Precio,@Cantidad
	  
		  WHILE @@FETCH_STATUS = 0
			  BEGIN
			  
					 IF @trans > 0
						BEGIN
							  SET @Id_Cliente = 0
							  SET @Id_Cta_Banco = 0

							  EXEC @ErrorRetorno = dbo.SP_CbteItem_Agr   @Id_Producto,@trans,@Cantidad,@Precio,@fecha,'',@Descripcion_Producto,@ID_Cliente,@Id_Cta_Banco
							  IF @ErrorRetorno <> 0
				                 RETURN 1
        				END  

			  FETCH NEXT FROM CUR_GENERAR_DETALLE INTO  @Id_Producto,@Descripcion_Producto,@Precio,@Cantidad
		 END  

		 SET @IMPORTE_CREDITO = (SELECT SUM(IMP_GRAVADO) FROM CBTES_ITEMS WHERE ID_TRANS = @TRANS ) * (@PORCENTAJE/100) 
		 SET @Id_Producto  = (SELECT Valor_String FROM xParametros where SETDatos= 1 AND idParametro ='Id_Prod_Desc_NVLP')
		 SET @Descripcion_Producto = (SELECT DESCRIPCION_DETALLADA FROM PRODUCTOS WHERE ID_PRODUCTO = @Id_Producto ) + ' % ' +Cast(@PORCENTAJE AS VARCHAR(10))


		 EXEC @ErrorRetorno = dbo.SP_CbteItem_Agr   @Id_Producto,@trans,-1,@IMPORTE_CREDITO,@fecha,'',@Descripcion_Producto,@ID_Cliente,@Id_Cta_Banco
 	  	 IF @ErrorRetorno <> 0
			 RETURN 1 

 ---------------------------------- GENERAR PERCEPCIONES
 
		 SELECT TR.ID_TIPO_RETEN_DEST,SUM(ISNULL(R.Imp_Base_Imponible,0)) BASE,SUM(ISNULL(R.IMPORTE * T.Compromete_Factura,0)) IMPORTE 
				INTO #CBTES_RETEN 
				FROM CBTES_RETEN R, CBTES C, Cbtes_Cond_Vtas V, cbtes_tipos T,CBTES_RETEN_TIPOS TR
				WHERE c.id_tipo_cbte = t.Id_Tipo_Cbte AND t.Compromete_Factura in (1,-1) 
				AND c.id_cond_vta = v.Id_Cond_Vta 
				AND c.Id_Estado_Cbte <> 3 
				AND c.Fecha >= @pFechaDesde
				AND c.Fecha <  DATEADD (dd, 1, @pFechaHasta)
				AND v.Plazo_Venc = @PLAZO
				AND v.Porc_Desc_Liquidacion = @PORCENTAJE
				AND v.Porc_Desc_Liquidacion > 0 
				AND R.Id_Tipo_Reten = ISNULL(TR.ID_TIPO_RETEN,'')
				AND ISNULL(TR.ID_TIPO_RETEN_DEST,'') <> ''
                AND ISNULL(R.ID_TIPO_RETEN,'') <> ''
				AND TR.TIPO = 'P'
				AND R.ID_TRANS = C.ID_TRANS
				AND EXISTS (SELECT 1 FROM PRODUCTOS P, CBTES_ITEMS I
				               WHERE P.Id_PROVEEDOR = @Id_Proveedor
								   AND I.ID_TRANS = C.ID_TRANS
								   AND I.Id_Producto = P.Id_Producto)
				GROUP BY TR.Id_Tipo_Reten_Dest
				PRINT 'INSERTO 1'
				INSERT INTO CBTES_RETEN (ID_TRANS,ID_TIPO_RETEN,IMPORTE,Observaciones,NRO,Imp_Pago_Acum,Imp_No_Imponible,Imp_Base_Imponible,Porc,Imp_Determinado,Imp_Reten_Ant,Fecha)
				SELECT @trans,R.ID_TIPO_RETEN_DEST,R.IMPORTE,'',0,0,0,R.Base,0,0,0,@fecha FROM #cbtes_reten R WHERE ISNULL(R.ID_TIPO_RETEN_DEST,'''') <> ''

		 DROP TABLE #cbtes_reten

      
----------------------------------- FIN PERCEPCIONES 

 ---------------------------------- GENERAR RETENCIONES

         IF @pIncluirPerccep = 1
		    BEGIN 
			        print 'genero retencion  '

				    DECLARE @TOT_NVLP DECIMAL(14,2)

					SET @TOT_NVLP = (SELECT SUM(IMP_GRAVADO) FROM CBTES_ITEMS WHERE ID_TRANS = @trans)


					print  @IMP_RETENCIONES
					print  @TOT_NVLP
					print  @TOTAL_FACTURADO

			    	INSERT INTO CBTES_RETEN (ID_TRANS,ID_TIPO_RETEN,IMPORTE,Observaciones,NRO,Imp_Pago_Acum,Imp_No_Imponible,Imp_Base_Imponible,Porc,Imp_Determinado,Imp_Reten_Ant,Fecha)
				    VALUES (@trans,@ID_TIPO_RETEN_DEST,(@IMP_RETENCIONES  * (@TOT_NVLP/@TOTAL_FACTURADO)) *-1,'',0,0,0,0,0,0,0,@fecha) 

            END
    
----------------------------------- FIN RETENCIONES


--------------GENERO Observacion con el detalle de las facturas
        SET @DETALLE_FACTURAS = 'Cbtes incluidos: '
        DECLARE CUR_GENERAR_NUMEROS CURSOR FOR

				SELECT C.Comprobante_Nro,C.Id_Trans,Count(*) as Cantidad
				FROM  CBTES C, Cbtes_Cond_Vtas V, cbtes_tipos T, PRODUCTOS P, CBTES_ITEMS I
				WHERE c.id_tipo_cbte = t.Id_Tipo_Cbte AND t.Compromete_Factura in (1,-1) 
				AND c.id_cond_vta = v.Id_Cond_Vta 
				AND c.Id_Estado_Cbte <> 3 
				AND c.Fecha >= @pFechaDesde
				AND c.Fecha <  DATEADD (dd, 1, @pFechaHasta) 
				AND P.Id_PROVEEDOR = @Id_Proveedor
				AND v.Plazo_Venc = @PLAZO
				AND v.Porc_Desc_Liquidacion = @PORCENTAJE
				AND v.Porc_Desc_Liquidacion > 0 
				AND I.Precio <> 0
				AND I.ID_TRANS = C.ID_TRANS
	 			AND I.Id_Producto = P.Id_Producto
				GROUP BY C.Comprobante_Nro,C.Id_Trans

		  OPEN CUR_GENERAR_NUMEROS
		  FETCH NEXT FROM CUR_GENERAR_NUMEROS INTO  @COMPROBANTE_NRO,@TRANSACCION,@CANT
	  
		  WHILE @@FETCH_STATUS = 0
			  BEGIN
			 
			  INSERT INTO @Trans_FC_NVLP (Id_Trans_NVLP_Destino, Id_Trans_FacVenta_Origen) VALUES (@trans, @TRANSACCION)
			  
			  SET @DETALLE_FACTURAS = RTRIM(LTRIM(@DETALLE_FACTURAS))  +' ' + CAST(@COMPROBANTE_NRO AS VARCHAR(10)) 

			  FETCH NEXT FROM CUR_GENERAR_NUMEROS INTO @COMPROBANTE_NRO,@TRANSACCION,@CANT
		  END  
		  CLOSE CUR_GENERAR_NUMEROS
		  DEALLOCATE CUR_GENERAR_NUMEROS

--------------Fin
      
         INSERT INTO @RESPUESTA 
		 EXEC @ErrorRetorno = dbo.CP_Cbtes_Cpra_Generar_Fin @Id_Proveedor,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',1,10,100,@trans 
		 IF @ErrorRetorno <> 0
			 RETURN 1

         INSERT INTO @RESPUESTA 
         EXEC @ErrorRetorno = dbo.CP_Cbtes_Cpra_Generar_Asi @Trans
		 IF @ErrorRetorno <> 0
			 RETURN 1

         UPDATE Cbtes SET Id_Estado_Cbte =  1, Lote = @pNro_Lote WHERE ID_TRANS = @TRANS 
		 UPDATE Cbtes SET Observacion =  @DETALLE_FACTURAS WHERE ID_TRANS = @TRANS 

		 CLOSE CUR_GENERAR_DETALLE
		 DEALLOCATE CUR_GENERAR_DETALLE

		 FETCH NEXT FROM CUR_GENERAR INTO @Id_Proveedor,@Plazo,@PORCENTAJE,@Importe

	  END
	  CLOSE CUR_GENERAR
	  DEALLOCATE CUR_GENERAR 

 	  SELECT * FROM #Res_Cond_Vta
		
		/*27/12/2019*/
		/*MODIFICO ASIENTO*/
		/*Actualizamos el DEBE del Alias 59 segun calculo.*/
		DECLARE @Id_Trans_NVLP INT
		DECLARE @GEN_REDONDEO  decimal(14,2)
		declare @redondeo decimal(14,2)

		SET @GEN_REDONDEO = 0
		SET @redondeo = 0

		DECLARE curActuDebeAlias59 CURSOR FOR
		SELECT DISTINCT Id_Trans_NVLP_Destino
		FROM @Trans_FC_NVLP


		OPEN curActuDebeAlias59
		FETCH NEXT FROM curActuDebeAlias59 INTO @Id_Trans_NVLP
		WHILE @@FETCH_STATUS = 0
		BEGIN

			/*ACTUALIZAMOS el monto de la cuenta Alias 59*/

		    	  set @redondeo = ISNULL((SELECT Imp_Gravado * -1 FROM Cbtes_items WHERE Id_Trans =  @Id_Trans_NVLP and Id_Producto = 'DESCUENTO'),0)
				  print '1 '
				  PRINT @redondeo

			UPDATE Cbtes_Ctas_Contables
			SET
			Debe = ISNULL((SELECT SUM(ISNULL(C.Imp_neto*T.Compromete_Factura, 0)) FROM Cbtes C, Cbtes_Tipos T WHERE C.Id_Tipo_Cbte = T.Id_tipo_Cbte and c.Id_Trans in (SELECT Id_Trans_FacVenta_Origen FROM @Trans_FC_NVLP WHERE Id_Trans_NVLP_Destino = @Id_Trans_NVLP)), 0),
			Observacion= 'Generado Automaticamente x CP_Liquido_Producto'
			WHERE
			Id_Trans = @Id_Trans_NVLP
			AND Alias = 59


			/*BORRAMOS la cuenta de descuento (Alias 787), ya que no se debe realizar en el asiento de NVLP*/
			DELETE Cbtes_Ctas_Contables
			WHERE
			Id_Trans = @Id_Trans_NVLP
			AND Alias = 787

			/*INSERTAMOS las cuentas del HABER por Zona*/
			DECLARE @Id_Alias_Cta_Cont_Haber	SMALLINT
			DECLARE @Id_Cta_Contable_Haber		INT
			DECLARE @Imp_Haber					DECIMAL(12,2)
			DECLARE @Fecha_NVLP					DATETIME
			DECLARE @Porc_Desc_Liquidacion		DECIMAL(7,2)
			DECLARE @Item_Cbtes_Cta_Cont		SMALLINT
				

			SELECT dbo.SF_Alias_Cta_Contable_X_Zona(CL.Id_Zona) AS Id_Alias_Cta_Cont, CCV.Porc_Desc_Liquidacion, SUM(ISNULL(CB.Imp_Neto,0)*T.Compromete_Factura) AS IMP_HABER  INTO  #DET_DESCUENTOS
			FROM Cbtes CB, Clientes CL, Cbtes_Cond_Vtas CCV, Cbtes_Tipos T
			WHERE
			ISNULL(CB.Id_Cliente, 0) = CL.Id_Cliente
			AND CB.Id_Tipo_Cbte = T.Id_Tipo_Cbte 
			AND ISNULL(CB.Id_Cond_Vta, '') = CCV.Id_Cond_Vta
			AND CB.Id_Trans IN (SELECT Id_Trans_FacVenta_Origen FROM @Trans_FC_NVLP WHERE Id_Trans_NVLP_Destino = @Id_Trans_NVLP)
			GROUP BY dbo.SF_Alias_Cta_Contable_X_Zona(CL.Id_Zona), CCV.Porc_Desc_Liquidacion


			ALTER TABLE #DET_DESCUENTOS ADD Id_Cta_Contable_Haber INT
			UPDATE #DET_DESCUENTOS SET Id_Cta_Contable_Haber =  (ISNULL(dbo.CF_Cta_Cont (Id_Alias_Cta_Cont, @Fecha_NVLP),0))

			DECLARE curAsixZona CURSOR FOR		
			SELECT Id_Alias_Cta_Cont,Porc_Desc_Liquidacion, IMP_HABER, Id_Cta_Contable_Haber   FROM #DET_DESCUENTOS
			OPEN curAsixZona	
			FETCH NEXT FROM curAsixZona INTO @Id_Alias_Cta_Cont_Haber, @Porc_Desc_Liquidacion, @Imp_Haber, @Id_Alias_Cta_Cont_Haber	
			WHILE @@FETCH_STATUS = 0
			BEGIN
		
				SET @Fecha_NVLP				= (SELECT ISNULL(Fecha, '19000101') FROM Cbtes WHERE Id_Trans = @Id_Trans_NVLP)
				SET @Imp_Haber				= (@Imp_Haber * (@Porc_Desc_Liquidacion  / 100))
				SET @Item_Cbtes_Cta_Cont	= ISNULL((SELECT MAX(ISNULL(Item, 0)) + 1 FROM Cbtes_Ctas_Contables WHERE Id_trans = @Id_Trans_NVLP), 1)

				SET @redondeo = @redondeo - @Imp_Haber

				INSERT Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,		Fecha,
				Debe,			Haber,					Observacion,
				Alias,			Id_Asiento,				Id_Centro_Costo,
				Item)
				VALUES
				(@Id_Trans_NVLP,		@Id_Cta_Contable_Haber,	@Fecha_NVLP,
				0,				@Imp_Haber,				'Generado Automaticamente x CP_Liquido_Producto',
				@Id_Alias_Cta_Cont_Haber, 0,			'',
				@Item_Cbtes_Cta_Cont)

				FETCH NEXT FROM curAsixZona INTO @Id_Alias_Cta_Cont_Haber, @Porc_Desc_Liquidacion, @Imp_Haber, @Id_Alias_Cta_Cont_Haber	
			END
			CLOSE curAsixZona
			DEALLOCATE curAsixZona

			DROP TABLE #DET_DESCUENTOS

			print '3 '
			print @redondeo

			IF @redondeo <= 0
			   BEGIN
			     UPDATE Cbtes_Ctas_Contables SET Haber = Haber - ABS(@redondeo) where Id_Trans = @Id_Trans_NVLP and Item = @Item_Cbtes_Cta_Cont
               END
			ELSE
			   BEGIN
			     UPDATE Cbtes_Ctas_Contables SET Haber = Haber + ABS(@redondeo) where Id_Trans = @Id_Trans_NVLP and Item = @Item_Cbtes_Cta_Cont
               END		

			/*FIN 27/12/2019*/
		
			FETCH NEXT FROM curActuDebeAlias59 INTO @Id_Trans_NVLP
		END
		CLOSE curActuDebeAlias59
		DEALLOCATE curActuDebeAlias59

		DROP TABLE #PORC_DESCUENTO
        DROP TABLE #TOTRETENIVA
			
	       
	END
 

--  exec CP_Liquido_Producto '20210424','20210430','p333Grun3',1,123,1

--  update cbtes set Id_Estado_Cbte = 3 where id_tipo_cbte = 'nvlp' and id_trans >  43902

--  select * from cbtes where id_tipo_cbte = 'nvlp' and fecha = '20210430'
 
